using System;
using System.Data;
using System.Text;

using gov.va.med.vbecs.Common;

namespace gov.va.med.vbecs.DAL.HL7AL
{

	#region Header

	//<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	//<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	//<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	//<Developers>
	//	<Developer>Brian Tomlin</Developer>
	//</Developers>
	//<SiteName>Hines OIFO</SiteName>
	//<CreationDate>5/10/2004</CreationDate>
	//<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	//<summary></summary>

	#endregion

	/// <summary>
	/// VbecsOmgMessage
	/// </summary>
	public class VbecsOmgMessage
	{
		private const string CARRIAGE_RETURN = "\x0D";
		private const string MESSAGE_TYPE = "OMG^O19";
		private static readonly string _msgDateTime = System.DateTime.Now.ToString("yyyyMMddhhmmsszzz").Replace(":","");

		///<Developers>
		///	<Developer>Brian Tomlin</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/14/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8305"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>Non-null VbecsOmgMessage object.</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="8306"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Blank Constructor for VbecsOmgMessage
		/// </summary>
		public VbecsOmgMessage() {}

		///<Developers>
		///	<Developer>Brian Tomlin</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/14/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8307"> 
		///		<ExpectedInput>This method requires a valid VistA connection and is not unit testable.</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="8308"> 
		///		<ExpectedInput>Null Order Update DataTable.</ExpectedInput>
		///		<ExpectedOutput>ArgumentNullException</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		///<summary>
		/// This method will send an HL7 update message to CPRS for status updates including
		/// Accepted, Canceled, and Complete.  The OrderStatusCode should be updated on the
		/// order prior to calling this method.
		/// CR 2961
		///</summary>
		public void PatientOrderUpdate( DataTable dtOrderUpdate )
		{
			if( dtOrderUpdate == null )
				throw( new ArgumentNullException("dtOrderUpdate") );

			// CR 2961
			HL7Interface intParms = new HL7Interface( InterfaceName.CPRS.ToString() );

			string _mshSegment = BuildMSHSegment( intParms );
			string _pidSegment = BuildPIDSegment( intParms,  dtOrderUpdate );
			string _orcSegment = BuildORCSegment( intParms, dtOrderUpdate );
			string _obrSegment = BuildOBRSegment( intParms, dtOrderUpdate );

			StringBuilder _msgLog = new StringBuilder();

			_msgLog.Append( _mshSegment );
			_msgLog.Append( _pidSegment );
			_msgLog.Append( _orcSegment );
			_msgLog.Append( _obrSegment );

			// File the message in the Message Log with a Pending Transmission status
			HL7MessageLog.InsertMessageLog( HL7MessageLog.GetMessageDataForMessageLogInsert( _msgLog.ToString(), MessageStatus.PendingTransmission, intParms, Common.UpdateFunction.HL7CprsInterface ) );
			
		}

		private static string BuildMSHSegment(HL7Interface intParms)
		{

			StringBuilder _msh = new StringBuilder();
			_msh.Append("MSH");										// MSH Segment ID
			_msh.Append(intParms.FieldSeparator);					// Field Separator
			_msh.Append(intParms.EncodingCharacters);				// Encoding Characters
			_msh.Append(intParms.FieldSeparator);
			_msh.Append(intParms.VbecsApplicationId.Trim());		// Sending Application
			_msh.Append(intParms.FieldSeparator);
			if( intParms.VbecsFacilityId != null )
			{
				_msh.Append(intParms.VbecsFacilityId.Trim());		// Sending Facility
			}
			_msh.Append(intParms.FieldSeparator);
			_msh.Append(intParms.InterfaceApplicationId.Trim());	// Receiving Application
			_msh.Append(intParms.FieldSeparator);
			if( intParms.InterfaceFacilityId != null )
			{
				_msh.Append(intParms.InterfaceFacilityId.Trim());		// Receiving Facility
			}
			_msh.Append(intParms.FieldSeparator);
			_msh.Append(_msgDateTime);								// HL7 DateTime
			_msh.Append(intParms.FieldSeparator);
			_msh.Append(intParms.FieldSeparator);
			_msh.Append(MESSAGE_TYPE);								// HL7 Message Type
			_msh.Append(intParms.FieldSeparator);
			_msh.Append("VBECS" + System.DateTime.Now.ToString("yMMddhhssffff"));								// Message Control ID
			_msh.Append(intParms.FieldSeparator);
			_msh.Append(intParms.ProcessingId);						// Processing ID
			_msh.Append(intParms.FieldSeparator);
			_msh.Append(intParms.VersionId.Trim());					// HL7 Version ID
			_msh.Append(CARRIAGE_RETURN);

			return _msh.ToString();
		}

		private static string BuildPIDSegment( HL7Interface intParms, DataTable OrderUpdate)
		{
			StringBuilder _pid = new StringBuilder();
			_pid.Append("PID");
			_pid.Append(intParms.FieldSeparator);
			_pid.Append(intParms.FieldSeparator);
			_pid.Append(intParms.FieldSeparator);
			_pid.Append(OrderUpdate.Rows[0]["VistaPatientId"].ToString());
			_pid.Append(intParms.FieldSeparator);
			_pid.Append(intParms.FieldSeparator);
			_pid.Append(OrderUpdate.Rows[0]["PatientLastName"].ToString());
			_pid.Append(intParms.EncodingCharacters[0]);
			_pid.Append(OrderUpdate.Rows[0]["PatientFirstName"].ToString());
			_pid.Append(intParms.EncodingCharacters[0]);
			_pid.Append(OrderUpdate.Rows[0]["PatientMiddleName"].ToString());
			_pid.Append(intParms.FieldSeparator);
			_pid.Append(intParms.FieldSeparator);
			_pid.Append(HL7DateFormat.ConvertDateTimeToHL7((DateTime)OrderUpdate.Rows[0]["PatientDob"]));
			_pid.Append(intParms.FieldSeparator);
			_pid.Append(OrderUpdate.Rows[0]["PatientSexCode"].ToString());
			_pid.Append(CARRIAGE_RETURN);

			return _pid.ToString();
		}

		private static string BuildORCSegment( HL7Interface intParms, DataTable OrderUpdate)
		{

			StringBuilder _orc = new StringBuilder();
			_orc.Append("ORC");
			_orc.Append(intParms.FieldSeparator);
			_orc.Append("SC");			// Always send a Status Change Order Control code			
			_orc.Append(intParms.FieldSeparator);
			_orc.Append(OrderUpdate.Rows[0]["CprsOrderNumber"].ToString());
			_orc.Append(intParms.EncodingCharacters[0]);
			_orc.Append("OR");
			_orc.Append(intParms.FieldSeparator);
			_orc.Append(OrderUpdate.Rows[0]["VbecsOrderNumber"].ToString());
			_orc.Append(intParms.EncodingCharacters[0]);
			_orc.Append("VBEC");
			_orc.Append(intParms.FieldSeparator);
			_orc.Append(OrderUpdate.Rows[0]["OrderGroupNumber"].ToString());
			_orc.Append(intParms.FieldSeparator);
			switch(OrderUpdate.Rows[0]["OrderStatusCode"].ToString())
			{
				case "A":
					_orc.Append("SC");
					break;
				case "C":
					_orc.Append("CM");
					break;
				case "P":
					_orc.Append("IP");
					break;
				case "X":
					_orc.Append("OC");
					break;
			}

			
			if(OrderUpdate.Rows[0]["CannedCommentText"] == null)
			{
				_orc.Append(CARRIAGE_RETURN);
				return _orc.ToString();
			}
			_orc.Append(intParms.FieldSeparator);
			_orc.Append(intParms.FieldSeparator);
			_orc.Append(intParms.FieldSeparator);
			_orc.Append(intParms.FieldSeparator);
			_orc.Append(intParms.FieldSeparator);
			_orc.Append(intParms.FieldSeparator);
			_orc.Append(intParms.FieldSeparator);
			_orc.Append(intParms.FieldSeparator);
			_orc.Append(intParms.FieldSeparator);
			_orc.Append(intParms.FieldSeparator);
			_orc.Append(intParms.FieldSeparator);
			_orc.Append(intParms.EncodingCharacters[0]);
			// CR 2147: Removed carriage return to address CR 2147
			_orc.Append(OrderUpdate.Rows[0]["CannedCommentText"].ToString().Replace("\r",string.Empty));  

			_orc.Append(CARRIAGE_RETURN);

			return _orc.ToString();
		}

		private static string BuildOBRSegment( HL7Interface intParms, DataTable OrderUpdate)
		{
			StringBuilder _obr = new StringBuilder();
			_obr.Append("OBR");
			_obr.Append(intParms.FieldSeparator);
			_obr.Append("1");
			_obr.Append(intParms.FieldSeparator);
			_obr.Append(OrderUpdate.Rows[0]["CprsOrderNumber"].ToString());
			_obr.Append(intParms.EncodingCharacters[0]);
			_obr.Append("OR");
			_obr.Append(intParms.FieldSeparator);
			_obr.Append(OrderUpdate.Rows[0]["VbecsOrderNumber"].ToString());
			_obr.Append(intParms.EncodingCharacters[0]);
			_obr.Append("VBEC");
			_obr.Append(intParms.FieldSeparator);
			_obr.Append(OrderUpdate.Rows[0]["CprsOrderableItemId"].ToString());

			
			if( OrderUpdate.Rows[0]["IsOrderedComponent"].ToString() == "1" )
			{
				_obr.Append(intParms.EncodingCharacters[0]);
				_obr.Append(OrderUpdate.Rows[0]["ComponentClassName"].ToString());
				_obr.Append(intParms.EncodingCharacters[0]);
				_obr.Append("99VBC");
				_obr.Append(intParms.EncodingCharacters[0]);
				_obr.Append(intParms.EncodingCharacters[0]);
				_obr.Append(OrderUpdate.Rows[0]["OrderSpecialInstructions"].ToString());
			}
			else
			{
				_obr.Append(intParms.EncodingCharacters[0]);
				_obr.Append(OrderUpdate.Rows[0]["OrderableTestName"].ToString());
				_obr.Append(intParms.EncodingCharacters[0]);
				_obr.Append("99VBC");
			}
			_obr.Append(intParms.FieldSeparator);
			_obr.Append(intParms.FieldSeparator);
			_obr.Append(intParms.FieldSeparator);
			_obr.Append(intParms.FieldSeparator);
			_obr.Append(intParms.FieldSeparator);
			_obr.Append(intParms.FieldSeparator);
			_obr.Append(intParms.FieldSeparator);
			_obr.Append(intParms.FieldSeparator);
			_obr.Append(intParms.FieldSeparator);
			_obr.Append(OrderUpdate.Rows[0]["LabOrderNumber"].ToString());
			_obr.Append(";;;");
			_obr.Append(OrderUpdate.Rows[0]["LabTestId"].ToString());

			_obr.Append(CARRIAGE_RETURN);

			return _obr.ToString();

		}
	}
}
